/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.ui.DialogWord;
import com.megacrit.cardcrawl.ui.buttons.LargeDialogOptionButton;
import java.util.ArrayList;
import java.util.Scanner;

public class RoomEventDialog {
    private Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color targetColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private static final Color PANEL_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private static final float COLOR_FADE_SPEED = 8.0f;
    private static boolean isMoving = false;
    private float animateTimer = 0.0f;
    private static final float ANIM_SPEED = 0.5f;
    private static boolean show = false;
    private static float curLineWidth = 0.0f;
    private static int curLine = 0;
    private static DialogWord.AppearEffect a_effect;
    private static Scanner s;
    private static GlyphLayout gl;
    private static ArrayList<DialogWord> words;
    private static boolean textDone;
    private static float wordTimer;
    private static final float WORD_TIME = 0.02f;
    private static final float CHAR_SPACING;
    private static final float LINE_SPACING;
    private static final float DIALOG_MSG_X;
    private static final float DIALOG_MSG_Y;
    private static final float DIALOG_MSG_W;
    public static ArrayList<LargeDialogOptionButton> optionList;
    public static int selectedOption;
    public static boolean waitForInput;

    public void update() {
        if (show) {
            if (isMoving) {
                this.animateTimer -= Gdx.graphics.getDeltaTime();
                if (this.animateTimer < 0.0f) {
                    this.animateTimer = 0.0f;
                    isMoving = false;
                }
            }
        } else if (isMoving && isMoving) {
            this.animateTimer -= Gdx.graphics.getDeltaTime();
            if (this.animateTimer < 0.0f) {
                this.animateTimer = 0.0f;
                isMoving = false;
            }
        }
        this.color = this.color.lerp(this.targetColor, Gdx.graphics.getDeltaTime() * 8.0f);
        if (show) {
            for (int i = 0; i < optionList.size(); ++i) {
                optionList.get(i).update();
                if (!RoomEventDialog.optionList.get((int)i).pressed || !waitForInput) continue;
                selectedOption = i;
                RoomEventDialog.optionList.get((int)i).pressed = false;
                waitForInput = false;
            }
        }
        if (Settings.lineBreakViaCharacter) {
            RoomEventDialog.bodyTextEffectCN();
        } else {
            RoomEventDialog.bodyTextEffect();
        }
        for (DialogWord w : words) {
            w.update();
        }
    }

    public static int getSelectedOption() {
        waitForInput = true;
        return selectedOption;
    }

    public void clear() {
        optionList.clear();
        words.clear();
        waitForInput = true;
    }

    public void show() {
        this.targetColor = PANEL_COLOR;
        this.animateTimer = 0.5f;
        show = true;
        isMoving = true;
    }

    public void show(String text) {
        RoomEventDialog.updateBodyText(text);
        this.show();
    }

    public void hide() {
        this.targetColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.animateTimer = 0.5f;
        show = false;
        isMoving = true;
        for (DialogWord w : words) {
            w.dialogFadeOut();
        }
        optionList.clear();
    }

    public static void removeDialogOption(int slot) {
        optionList.remove(slot);
    }

    public static void addDialogOption(String text) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text));
    }

    public static void addDialogOption(String text, AbstractCard previewCard) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text, previewCard));
    }

    public static void addDialogOption(String text, boolean isDisabled) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text, isDisabled));
    }

    public static void addDialogOption(String text, boolean isDisabled, AbstractCard previewCard) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text, isDisabled, previewCard));
    }

    public static void updateDialogOption(int slot, String text) {
        optionList.set(slot, new LargeDialogOptionButton(slot, text));
    }

    public static void updateBodyText(String text) {
        RoomEventDialog.updateBodyText(text, DialogWord.AppearEffect.BUMP_IN);
    }

    public static void updateBodyText(String text, DialogWord.AppearEffect ae) {
        s = new Scanner(text);
        words.clear();
        textDone = false;
        a_effect = ae;
        curLineWidth = 0.0f;
        curLine = 0;
    }

    public static void clearRemainingOptions() {
        for (int i = optionList.size() - 1; i > 0; --i) {
            optionList.remove(i);
        }
    }

    private static void bodyTextEffectCN() {
        if ((wordTimer -= Gdx.graphics.getDeltaTime()) < 0.0f && !textDone) {
            wordTimer = 0.02f;
            if (s.hasNext()) {
                DialogWord.WordEffect effect;
                String word = s.next();
                if (word.equals("NL")) {
                    ++curLine;
                    curLineWidth = 0.0f;
                    return;
                }
                DialogWord.WordColor color = DialogWord.identifyWordColor(word);
                if (color != DialogWord.WordColor.DEFAULT) {
                    word = word.substring(2, word.length());
                }
                if ((effect = DialogWord.identifyWordEffect(word)) != DialogWord.WordEffect.NONE) {
                    word = word.substring(1, word.length() - 1);
                }
                for (int i = 0; i < word.length(); ++i) {
                    String tmp = Character.toString(word.charAt(i));
                    gl.setText(FontHelper.eventBodyText, tmp);
                    if (curLineWidth + RoomEventDialog.gl.width > DIALOG_MSG_W) {
                        ++curLine;
                        curLineWidth = RoomEventDialog.gl.width;
                    } else {
                        curLineWidth += RoomEventDialog.gl.width;
                    }
                    words.add(new DialogWord(FontHelper.eventBodyText, tmp, a_effect, effect, color, DIALOG_MSG_X + curLineWidth - RoomEventDialog.gl.width, DIALOG_MSG_Y - LINE_SPACING * (float)curLine, curLine));
                    if (show) continue;
                    words.get(words.size() - 1).dialogFadeOut();
                }
            } else {
                textDone = true;
                s.close();
            }
        }
    }

    private static void bodyTextEffect() {
        if ((wordTimer -= Gdx.graphics.getDeltaTime()) < 0.0f && !textDone) {
            wordTimer = 0.02f;
            if (s.hasNext()) {
                DialogWord.WordEffect effect;
                String word = s.next();
                if (word.equals("NL")) {
                    ++curLine;
                    curLineWidth = 0.0f;
                    return;
                }
                DialogWord.WordColor color = DialogWord.identifyWordColor(word);
                if (color != DialogWord.WordColor.DEFAULT) {
                    word = word.substring(2, word.length());
                }
                if ((effect = DialogWord.identifyWordEffect(word)) != DialogWord.WordEffect.NONE) {
                    word = word.substring(1, word.length() - 1);
                }
                gl.setText(FontHelper.textOnlyEventBody, word);
                if (curLineWidth + RoomEventDialog.gl.width > DIALOG_MSG_W) {
                    ++curLine;
                    curLineWidth = RoomEventDialog.gl.width + CHAR_SPACING;
                } else {
                    curLineWidth += RoomEventDialog.gl.width + CHAR_SPACING;
                }
                words.add(new DialogWord(FontHelper.textOnlyEventBody, word, a_effect, effect, color, DIALOG_MSG_X + curLineWidth - RoomEventDialog.gl.width, DIALOG_MSG_Y - LINE_SPACING * (float)curLine, curLine));
                if (!show) {
                    words.get(words.size() - 1).dialogFadeOut();
                }
            } else {
                textDone = true;
                s.close();
            }
        }
    }

    public void render(SpriteBatch sb) {
        if (!AbstractDungeon.player.isDead) {
            for (DialogWord w : words) {
                w.render(sb, (float)Settings.HEIGHT - 525.0f * Settings.scale);
            }
            for (LargeDialogOptionButton b : optionList) {
                b.render(sb);
            }
        }
    }

    static {
        gl = new GlyphLayout();
        words = new ArrayList();
        textDone = true;
        wordTimer = 0.0f;
        CHAR_SPACING = 8.0f * Settings.scale;
        LINE_SPACING = 30.0f * Settings.scale;
        DIALOG_MSG_X = (float)Settings.WIDTH * 0.1f;
        DIALOG_MSG_Y = 250.0f * Settings.scale;
        DIALOG_MSG_W = (float)Settings.WIDTH * 0.8f;
        optionList = new ArrayList();
        selectedOption = -1;
        waitForInput = true;
    }
}

